ORCA/M Asm65816 2.1.0

0001 930A                       title 'Event Manager        GS ROM 3.0' 
0002 930A              ********************************************************
0003 930A              *                                                      *
0004 930A              *                 Event Manager                        *
0005 930A              *                                                      *
0006 930A              ********************************************************
0007 930A
0008 930A              ********************************************************
0009 930A              *                                                      *
0010 930A              *              Copyright (C) 1985-1989                 *
0011 930A              *              Apple Computer, Inc.                    *
0012 930A              *              All Rights Reserved                     *
0013 930A              *                                                      *
0014 930A              ********************************************************
0015 930A
0016 930A
0017 930A              ********************************************************
0018 930A              *                                                      *
0019 930A              * Change History                                       *
0020 930A              *                                                      *
0021 930A              * 24-Feb-91         Dave Lyons
0022 930A              *
0023 930A              * Added EMStartUp call to UseCoolMousePos to set the mouse position from
0024 930A              * MessageCenter message number 6.
0025 930A              *
0026 930A              ********************************************************
0027 930A              *
0028 930A              * 3-Jun-92          Dave Lyons
0029 930A              *
0030 930A              * UseCoolMousePos (called by EMStartUp in both patch files) now puts the
0031 930A              * mouse at (26,17) for 640 (or (13,17) in 320) if there's no Message #6.
0032 930A              *
0033 930A              ********************************************************
0034 930A
0035 930A
0036 930A              ****************************************************************
0037 930A              *
0038 930A              * UseCoolMousePos
0039 930A              *
0040 930A              * 24-Feb-91 Dave Lyons
0041 930A              *
0042 930A              * Check for MessageCenter message #6 containing the mouse
0043 930A              * position (Y,X in 640 coordinates).
0044 930A              *
0045 930A              * If the message is there, call FakeMouse to move the mouse
0046 930A              * somewhere nice.  If we're in 320, we need to cut the X
0047 930A              * coordinate in half first.
0048 930A              *
0049 930A              ****************************************************************
0050 930A              UseCoolMousePos proc export 
0051 930A
0052 930A F4 00 00              pea   0
0053 930D A2 04 06 22           _QDStatus 
0054 9314 68                    pla   
0055 9315 F0 75                 beq   @exit
0056 9317
0057 9317 48                    pha   
0058 9318 48                    pha                            ;space for GetMsgHandle result
0059 9319 F4 01 00              pea   1                        ;get message by type
0060 931C F4 00 00 F4           pushlong #6                    ;message type=6
0061 9322 A2 01 1A 22           _GetMsgHandle 
0062 9329 FA                    plx   
0063 932A 7A                    ply   
0064 932B              *** added 3-Jun-92 DAL -- Use nonzero default position
0065 932B 90 06                 bcc   @gotMessage
0066 932D A2 8D 96              ldx   #defaultMsgHandle
0067 9330 A0 02 00              ldy   #^defaultMsgHandle
0068 9333              @gotMessage  
0069 9333              *** end 3-Jun-92
0070 9333
0071 9333              *** dereference message handle to <1
0072 9333 0B                    phd   
0073 9334 5A                    phy   
0074 9335 DA                    phx   
0075 9336 3B                    tsc   
0076 9337 5B                    tcd   
0077 9338 A0 02 00              ldy   #2
0078 933B B7 01                 lda   [1],y
0079 933D AA                    tax   
0080 933E A7 01                 lda   [1]
0081 9340 85 01                 sta   1
0082 9342 86 03                 stx   3
0083 9344
0084 9344              *** put Y value at 1, X value at 3
0085 9344 A0 08 00              ldy   #6+2                     ;offset to X value
0086 9347 B7 01                 lda   [1],y
0087 9349 AA                    tax   
0088 934A 88                    dey   
0089 934B 88                    dey   
0090 934C B7 01                 lda   [1],y
0091 934E 85 01                 sta   1
0092 9350 86 03                 stx   3
0093 9352
0094 9352              *** destroy the message from MessageCenter (moved down, 3-Jun-92 DAL)
0095 9352 F4 03 00              pea   3                        ;delete message
0096 9355 F4 06 00              pea   6                        ;message type
0097 9358 48                    pha   
0098 9359 48                    pha   
0099 935A A2 01 15 22           _MessageCenter 
0100 9361
0101 9361              *** If we're in 320, cut X value in half
0102 9361 F4 00 00              pea   0
0103 9364 A2 04 17 22           _GetMasterSCB 
0104 936B 68                    pla   
0105 936C B0 07                 bcs   @not320
0106 936E 29 80 00              and   #$0080
0107 9371 D0 02                 bne   @not320
0108 9373 46 03                 lsr   3
0109 9375              @not320   
0110 9375
0111 9375              *** do the FakeMouse call
0112 9375 F4 02 00              pea   2                        ;flag that the XY position has changed
0113 9378 F4 00 00              pea   0                        ;modifiers
0114 937B D4 03                 pei   3                        ;X value
0115 937D D4 01                 pei   1                        ;Y value
0116 937F F4 00 00              pea   0                        ;button states
0117 9382 A2 06 19 22           _FakeMouse 
0118 9389
0119 9389 68                    pla   
0120 938A 68                    pla   
0121 938B 2B                    pld   
0122 938C
0123 938C 6B           @exit    rtl   
0124 938D
0125 938D              *** added 3-Jun-92 DAL
0126 938D 91 96 02 00  defaultMsgHandle DC L:defaultPosMsg
0127 9391 00 00 00 00  defaultPosMsg DC L:0                    ;link
0128 9395 06 00                 DC W:6                         ;msg type
0129 9397 11 00 1A 00           DC W:17,26
0130 939B              *** end 3-Jun-92
0131 939B
0132 939B              ****************************************************************
0133 939B              *
0134 939B              * CreateMouseMessage
0135 939B              *
0136 939B              * 24-Feb-91 Dave Lyons
0137 939B              *
0138 939B              * Create MessageCenter message #6 containing the mouse
0139 939B              * position (Y,X, in 640 coordinates).
0140 939B              *
0141 939B              ****************************************************************
0142 939B              CreateMouseMessage proc export 
0143 939B 48                    pha   
0144 939C 48                    pha                            ;space for new handle
0145 939D F4 00 00              pea   0
0146 93A0 F4 0A 00              pea   6+4                      ;6 bytes overhead + 4 bytes data
0147 93A3 F4 06 40              pea   $4006                    ;memory ID
0148 93A6 F4 00 00              pea   0                        ;attributes
0149 93A9 48                    pha   
0150 93AA 48                    pha                            ;location (ignored)
0151 93AB A2 02 09 22           _NewHandle 
0152 93B2
0153 93B2 F4 01 00              pea   1                        ;add message (MessageCenter parameters)
0154 93B5 F4 06 00              pea   6                        ;message type
0155 93B8 A3 07                 lda   7,s
0156 93BA 48                    pha   
0157 93BB A3 07                 lda   7,s
0158 93BD 48                    pha                            ;pushed a 2nd copy of the handle, for MessageCenter
0159 93BE
0160 93BE 0B                    phd   
0161 93BF 48                    pha   
0162 93C0 48                    pha                            ;space for pointer
0163 93C1 3B                    tsc   
0164 93C2 5B                    tcd   
0165 93C3              @ptr     equ   1
0166 93C3              @hndl    equ   7
0167 93C3
0168 93C3 48                    pha   
0169 93C4 48                    pha   
0170 93C5 48                    pha   
0171 93C6 A2 03 17 22           _ReadMouse 
0172 93CD 68                    pla                            ;ignore stat/mode from ReadMouse
0173 93CE
0174 93CE              *** if we're in 320, double the X value
0175 93CE F4 00 00              pea   0
0176 93D1 A2 04 17 22           _GetMasterSCB 
0177 93D8 68                    pla   
0178 93D9 B0 0A                 bcs   @not320
0179 93DB 29 80 00              and   #$0080
0180 93DE D0 05                 bne   @not320
0181 93E0 A3 03                 lda   3,s
0182 93E2 0A                    asl   a
0183 93E3 83 03                 sta   3,s
0184 93E5              @not320   
0185 93E5
0186 93E5 A0 02 00              ldy   #2
0187 93E8 B7 07                 lda   [@hndl],y
0188 93EA 85 03                 sta   @ptr+2
0189 93EC A7 07                 lda   [@hndl]
0190 93EE 85 01                 sta   @ptr
0191 93F0
0192 93F0 68                    pla                            ;pull Y value from ReadMouse
0193 93F1 A0 06 00              ldy   #6                       ;offset to Y position data in message handle
0194 93F4 97 01                 sta   [@ptr],y
0195 93F6 68                    pla                            ;pull X value from ReadMouse
0196 93F7 A0 08 00              ldy   #8                       ;offset to X position data in message handle
0197 93FA 97 01                 sta   [@ptr],y
0198 93FC
0199 93FC 68                    pla   
0200 93FD 68                    pla   
0201 93FE 2B                    pld   
0202 93FF A2 01 15 22           _MessageCenter                 ;add the message
0203 9406 A2 02 10 22           _DisposeHandle                 ;get rid of our copy of the handle
0204 940D 6B                    rtl   
0205 940E
0206 940E                       EndP 
0207 940E
0208 940E
0209 940E                       END   
